<?php

namespace App\Modules\Finance\Migrations\AccountingRestriction;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccountingRestriction extends Model 
{

    protected $table = 'accounting_restrictions';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function restrictionType()
    {
        return $this->belongsTo('RestrictionType', 'restriction_type');
    }

    public function customer()
    {
        return $this->belongsTo('Customer', 'customer_id');
    }

}